/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.RSAPIInject;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.ValueTypeListProxyPositionedNetworkMasterFluidInventory;
import org.cyclops.integrateddynamicscompat.modcompat.refinedstorage.aspect.ValueTypeListProxyPositionedNetworkMasterItemInventory;

public class RefinedStorageAspects {
    @RSAPIInject
    public static IRSAPI RS;

    public static final class Write {
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROPERTY_SKIPCRAFTING = new AspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean>(ValueTypes.BOOLEAN, "aspect.aspecttypes.integrateddynamics.boolean.refinedstorage.skipcrafting");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROPERTY_SKIPSTORAGE = new AspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean>(ValueTypes.BOOLEAN, "aspect.aspecttypes.integrateddynamics.boolean.refinedstorage.skipstorage");
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_CRAFTCOUNT = new AspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.refinedstorage.craftcount");
        public static final IAspectProperties CRAFTING_PROPERTIES = new AspectProperties((Collection<IAspectPropertyTypeInstance>)ImmutableList.of(PROPERTY_SKIPCRAFTING, PROPERTY_SKIPSTORAGE, PROPERTY_CRAFTCOUNT));
        public static final IAspectWrite<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> ITEMSTACK_CRAFT;
        public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> LIST_CRAFT;
        public static final IAspectWrite<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_CANCELCRAFT;
        public static final IAspectWrite<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> ITEMSTACK_CANCELCRAFT;
        public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> LIST_CANCELCRAFT;

        protected static Void triggerItemStackCrafting(IAspectProperties aspectProperties, INetwork networkMaster, ItemStack itemStack) {
            int compareFlags = 1;
            ICalculationResult craftingTask = networkMaster.getCraftingManager().create(itemStack, aspectProperties.getValue(PROPERTY_CRAFTCOUNT).getRawValue());
            if (craftingTask != null) {
                ItemStack present;
                if (aspectProperties.getValue(PROPERTY_SKIPCRAFTING).getRawValue()) {
                    for (ICraftingTask task : networkMaster.getCraftingManager().getTasks()) {
                        for (ItemStack output : task.getPattern().getOutputs()) {
                            if (!RS.getComparer().isEqual(output, itemStack, compareFlags)) continue;
                            return null;
                        }
                    }
                }
                if (aspectProperties.getValue(PROPERTY_SKIPSTORAGE).getRawValue() && (present = (ItemStack)networkMaster.getItemStorageCache().getList().get((Object)itemStack, compareFlags)) != null && present.m_41613_() >= itemStack.m_41613_()) {
                    return null;
                }
                if (craftingTask.isOk()) {
                    networkMaster.getCraftingManager().start(craftingTask.getTask());
                }
            }
            return null;
        }

        static {
            CRAFTING_PROPERTIES.setValue(PROPERTY_SKIPCRAFTING, ValueTypeBoolean.ValueBoolean.of(true));
            CRAFTING_PROPERTIES.setValue(PROPERTY_SKIPSTORAGE, ValueTypeBoolean.ValueBoolean.of(false));
            CRAFTING_PROPERTIES.setValue(PROPERTY_CRAFTCOUNT, ValueTypeInteger.ValueInteger.of(1));
            ITEMSTACK_CRAFT = AspectWriteBuilders.BUILDER_ITEMSTACK.appendKind("refinedstorage").withProperties(CRAFTING_PROPERTIES).handle(input -> {
                if (!((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue().m_41619_()) {
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    return BlockEntityHelpers.get((DimPos)pos, INetworkNodeProxy.class).map(networkNodeProxy -> {
                        INetwork networkMaster = networkNodeProxy.getNode().getNetwork();
                        if (networkMaster != null) {
                            ItemStack itemStack = ((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue();
                            return Write.triggerItemStackCrafting((IAspectProperties)input.getMiddle(), networkMaster, itemStack);
                        }
                        return null;
                    }).orElse(null);
                }
                return null;
            }, "craft").buildWrite();
            LIST_CRAFT = AspectWriteBuilders.BUILDER_LIST.appendKind("refinedstorage").withProperties(CRAFTING_PROPERTIES).handle(input -> {
                DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                BlockEntityHelpers.get((DimPos)pos, INetworkNodeProxy.class).ifPresent(networkNodeProxy -> {
                    INetwork networkMaster = networkNodeProxy.getNode().getNetwork();
                    if (networkMaster != null && ((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() == ValueTypes.OBJECT_ITEMSTACK) {
                        for (IValue value : ((ValueTypeList.ValueList)input.getRight()).getRawValue()) {
                            ValueObjectTypeItemStack.ValueItemStack valueItemStack = (ValueObjectTypeItemStack.ValueItemStack)value;
                            if (valueItemStack.getRawValue().m_41619_()) continue;
                            ItemStack itemStack = valueItemStack.getRawValue();
                            Write.triggerItemStackCrafting((IAspectProperties)input.getMiddle(), networkMaster, itemStack);
                        }
                    }
                });
                return null;
            }, "craft").buildWrite();
            BOOLEAN_CANCELCRAFT = AspectWriteBuilders.BUILDER_BOOLEAN.appendKind("refinedstorage").handle(input -> {
                if (((ValueTypeBoolean.ValueBoolean)input.getRight()).getRawValue()) {
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    BlockEntityHelpers.get((DimPos)pos, INetworkNodeProxy.class).ifPresent(networkNodeProxy -> {
                        INetwork networkMaster = networkNodeProxy.getNode().getNetwork();
                        if (networkMaster != null) {
                            ArrayList craftingTasks = Lists.newArrayList((Iterable)networkMaster.getCraftingManager().getTasks());
                            for (ICraftingTask craftingTask : craftingTasks) {
                                networkMaster.getCraftingManager().cancel(craftingTask.getId());
                            }
                        }
                    });
                }
                return null;
            }, "cancelcraft").buildWrite();
            ITEMSTACK_CANCELCRAFT = AspectWriteBuilders.BUILDER_ITEMSTACK.appendKind("refinedstorage").handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueObjectTypeItemStack.ValueItemStack>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueObjectTypeItemStack.ValueItemStack> input) {
                    if (!((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue().m_41619_()) {
                        DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                        BlockEntityHelpers.get((DimPos)pos, INetworkNodeProxy.class).ifPresent(networkNodeProxy -> {
                            INetwork networkMaster = networkNodeProxy.getNode().getNetwork();
                            if (networkMaster != null) {
                                ItemStack itemStack = ((ValueObjectTypeItemStack.ValueItemStack)input.getRight()).getRawValue();
                                ArrayList craftingTasks = Lists.newArrayList((Iterable)networkMaster.getCraftingManager().getTasks());
                                int compareFlags = 1;
                                block0: for (ICraftingTask craftingTask : craftingTasks) {
                                    for (ItemStack output : craftingTask.getPattern().getOutputs()) {
                                        if (!RS.getComparer().isEqual(output, itemStack, compareFlags)) continue;
                                        networkMaster.getCraftingManager().cancel(craftingTask.getId());
                                        continue block0;
                                    }
                                }
                            }
                        });
                    }
                    return null;
                }
            }, "cancelcraft").buildWrite();
            LIST_CANCELCRAFT = AspectWriteBuilders.BUILDER_LIST.appendKind("refinedstorage").handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Void>(){

                @Override
                public Void getOutput(Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList> input) {
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    BlockEntityHelpers.get((DimPos)pos, INetworkNodeProxy.class).ifPresent(networkNodeProxy -> {
                        INetwork networkMaster = networkNodeProxy.getNode().getNetwork();
                        if (networkMaster != null && ((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() == ValueTypes.OBJECT_ITEMSTACK) {
                            ArrayList craftingTasks = Lists.newArrayList((Iterable)networkMaster.getCraftingManager().getTasks());
                            int compareFlags = 1;
                            for (ICraftingTask craftingTask : craftingTasks) {
                                block1: for (ItemStack output : craftingTask.getPattern().getOutputs()) {
                                    for (IValue value : ((ValueTypeList.ValueList)input.getRight()).getRawValue()) {
                                        ValueObjectTypeItemStack.ValueItemStack valueItemStack = (ValueObjectTypeItemStack.ValueItemStack)value;
                                        if (valueItemStack.getRawValue().m_41619_() || !RS.getComparer().isEqual(output, valueItemStack.getRawValue(), compareFlags)) continue;
                                        networkMaster.getCraftingManager().cancel(craftingTask.getId());
                                        continue block1;
                                    }
                                }
                            }
                        }
                    });
                    return null;
                }
            }, "cancelcraft").buildWrite();
        }
    }

    public static final class Read {
        public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, Optional<INetworkNode>> PROP_GET_NODE = input -> {
            DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
            return BlockEntityHelpers.get((DimPos)pos, INetworkNodeProxy.class).map(INetworkNodeProxy::getNode);
        };
        public static final IAspectValuePropagator<Optional<INetworkNode>, Optional<INetwork>> PROP_GET_MASTER = input -> input.map(INetworkNode::getNetwork);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Optional<INetwork>> BUILDER_BOOLEAN = AspectReadBuilders.BUILDER_BOOLEAN.handle(PROP_GET_NODE, "refinedstorage").handle(PROP_GET_MASTER);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Optional<INetwork>> BUILDER_LIST = AspectReadBuilders.BUILDER_LIST.handle(PROP_GET_NODE, "refinedstorage").handle(PROP_GET_MASTER);

        public static final class Fluid {
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_FLUIDSTACKS = BUILDER_LIST.appendKind("fluid").handle(networkMaster -> networkMaster.map(network -> ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedNetworkMasterFluidInventory(DimPos.of((Level)network.getLevel(), (BlockPos)network.getPosition())))).orElseGet(() -> ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_FLUIDSTACK, Collections.emptyList())), "fluidstacks").buildRead();
        }

        public static final class Inventory {
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_ITEMSTACKS = BUILDER_LIST.appendKind("inventory").handle(networkMaster -> networkMaster.map(network -> ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyPositionedNetworkMasterItemInventory(DimPos.of((Level)network.getLevel(), (BlockPos)network.getPosition())))).orElseGet(() -> ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList())), "itemstacks").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_CRAFTABLEITEMS = BUILDER_LIST.appendKind("inventory").handle(networkMaster -> networkMaster.map(network -> {
                ArrayList itemStacks = Lists.newArrayList();
                for (ICraftingPattern craftingPattern : network.getCraftingManager().getPatterns()) {
                    for (ItemStack itemStack : craftingPattern.getOutputs()) {
                        itemStacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                    }
                }
                return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, itemStacks);
            }).orElseGet(() -> ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList())), "craftableitems").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_CRAFTINGITEMS = BUILDER_LIST.appendKind("inventory").handle(new IAspectValuePropagator<Optional<INetwork>, ValueTypeList.ValueList>(){

                protected void addPatternItemStacks(List<ValueObjectTypeItemStack.ValueItemStack> itemStacks, ICraftingTask craftingTask) {
                    ICraftingPattern craftingPattern = craftingTask.getPattern();
                    for (ItemStack itemStack : craftingPattern.getOutputs()) {
                        itemStacks.add(ValueObjectTypeItemStack.ValueItemStack.of(itemStack));
                    }
                }

                @Override
                public ValueTypeList.ValueList getOutput(Optional<INetwork> networkMaster) {
                    return networkMaster.map(network -> {
                        ArrayList itemStacks = Lists.newArrayList();
                        for (ICraftingTask craftingTask : network.getCraftingManager().getTasks()) {
                            this.addPatternItemStacks(itemStacks, craftingTask);
                        }
                        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, itemStacks);
                    }).orElseGet(() -> ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList()));
                }
            }, "craftingitems").buildRead();
        }

        public static final class Network {
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_APPLICABLE = BUILDER_BOOLEAN.appendKind("network").handle(Optional::isPresent).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "applicable").buildRead();
        }
    }
}

